(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6202,        178]*)
(*NotebookOutlinePosition[      7043,        205]*)
(*  CellTagsIndexPosition[      6999,        201]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \( (*\ 
      To\ compute\ Gauss\ points\ x_i\ and\ the\ weights\ for\ Gauss\ 
          quadrature\ for\ \n\t\tn = 
        8\ for\ the\ interval\ \((\(-1\), \ 1)\)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LegendreP[8, x]\)], "Input"],

Cell[BoxData[
    \(35\/128 - \(315\ x\^2\)\/32 + \(3465\ x\^4\)\/64 - \(3003\ x\^6\)\/32 + 
      \(6435\ x\^8\)\/128\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[LegendreP[8, x], x]\)], "Input"],

Cell[BoxData[
    \(\(-\(\(315\ x\)\/16\)\) + \(3465\ x\^3\)\/16 - \(9009\ x\^5\)\/16 + 
      \(6435\ x\^7\)\/16\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[LegendreP[8, x] == 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] \(-0.960289856497536931`\)}, {
        x \[Rule] \(-0.796666477413626239`\)}, {
        x \[Rule] \(-0.52553240991632899`\)}, {
        x \[Rule] \(-0.183434642495649811`\)}, {
        x \[Rule] 0.183434642495649811`}, {x \[Rule] 0.52553240991632899`}, {
        x \[Rule] 0.796666477413626239`}, {x \[Rule] 0.960289856497536931`}}
      \)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(gausspoints = {\(-0.960289856497536931`\), \(-0.796666477413626239`\), 
        \(-0.52553240991632899`\), \(-0.183434642495649811`\), 
        0.183434642495649811`, 0.52553240991632899`, 0.796666477413626239`, 
        0.960289856497536931`}\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x_] := \ 
      2/\((\ \((1 - x^2)\) 
            \((\(-\(\(315\ x\)\/16\)\) + \(3465\ x\^3\)\/16 - 
                  \(9009\ x\^5\)\/16 + \(6435\ x\^7\)\/16)\)^2)\); \n
    weights = 
      Map[f, {\(-0.960289856497536931`\), \(-0.796666477413626239`\), 
          \(-0.52553240991632899`\), \(-0.183434642495649811`\), 
          0.183434642495649811`, 0.52553240991632899`, 0.796666477413626239`, 
          0.960289856497536931`}]\)], "Input"],

Cell[BoxData[
    \({0.101228536290374893`, 0.222381034453378623`, 0.31370664587788748`, 
      0.362683783378361912`, 0.362683783378361912`, 0.31370664587788748`, 
      0.222381034453378623`, 0.101228536290374893`}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ 
      Now\ to\ obtain\ the\ Gausspoints\ \[Xi]_i\ for\ the\ interval\ 
        \((0, \[Pi])\), \ 
      use\ the\ formula\ \ \[Xi]_i = \[Pi]\ \((1 + x_i)\)/2\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[a_] := \ \[Pi] \((1 + a)\)/2\ ; \n
    newgausspoints = 
      Map[g, {\(-0.960289856497536931`\), \(-0.796666477413626239`\), 
          \(-0.52553240991632899`\), \(-0.183434642495649811`\), 
          0.183434642495649811`, 0.52553240991632899`, 0.796666477413626239`, 
          0.960289856497536931`}]\)], "Input"],

Cell[BoxData[
    \({0.0623765475501671851`, 0.319395550392942961`, 0.745291947686657074`, 
      1.28265786415579485`, 1.85893478943399852`, 2.39630070590313604`, 
      2.82219710319685024`, 3.07921610603962569`}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ 
      These\ are\ the\ values\ of\ \[Xi]_i\ in\ radians . \n\t\t\tNow\ these\ 
        values\ in\ degrees\ \(are : \)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(h[a_] := \((180*a)\)/\[Pi]; \n
    degreegausspoints = 
      Map[h, {0.0623765475501671851`, 0.319395550392942961`, 
          0.745291947686657074`, 1.28265786415579485`, 1.85893478943399852`, 
          2.39630070590313604`, 2.82219710319685024`, 3.07921610603962569`}]\ 
    \)\)], "Input"],

Cell[BoxData[
    \({3.57391291522167486`, 18.3000170327736348`, 42.7020831075303952`, 
      73.4908821753915209`, 106.509117824608479`, 137.297916892469618`, 
      161.699982967226363`, 176.426087084778293`}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ To\ obtain\ gausspoints\ for\ the\ interval\ \((0, 1)\), \n\t
      use\ the\ formula\ \ \[Xi]_i = \((1 + x_i)\)/2\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(p[a_] := \ \((1 + a)\)/2\ ; \n
    zero_onegausspoints = 
      Map[p, {\(-0.960289856497536931`\), \(-0.796666477413626239`\), 
          \(-0.52553240991632899`\), \(-0.183434642495649811`\), 
          0.183434642495649811`, 0.52553240991632899`, 0.796666477413626239`, 
          0.960289856497536931`}]\)], "Input"],

Cell[BoxData[
    \({0.0198550717512315237`, 0.101666761293186858`, 0.237233795041835504`, 
      0.408282678752175076`, 0.591717321247824923`, 0.76276620495816445`, 
      0.898333238706813119`, 0.980144928248768465`}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{505, 275},
WindowMargins->{{Automatic, 161}, {24, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 203, 4, 59, "Input"],

Cell[CellGroupData[{
Cell[1937, 57, 48, 1, 27, "Input"],
Cell[1988, 60, 132, 2, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2157, 67, 54, 1, 27, "Input"],
Cell[2214, 70, 127, 2, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2378, 77, 66, 1, 27, "Input"],
Cell[2447, 80, 384, 7, 56, "Output"]
}, Open  ]],
Cell[2846, 90, 276, 4, 91, "Input"],

Cell[CellGroupData[{
Cell[3147, 98, 470, 9, 158, "Input"],
Cell[3620, 109, 230, 3, 41, "Output"]
}, Open  ]],
Cell[3865, 115, 203, 4, 59, "Input"],

Cell[CellGroupData[{
Cell[4093, 123, 341, 6, 107, "Input"],
Cell[4437, 131, 228, 3, 41, "Output"]
}, Open  ]],
Cell[4680, 137, 164, 3, 43, "Input"],

Cell[CellGroupData[{
Cell[4869, 144, 316, 6, 107, "Input"],
Cell[5188, 152, 224, 3, 41, "Output"]
}, Open  ]],
Cell[5427, 158, 159, 2, 43, "Input"],

Cell[CellGroupData[{
Cell[5611, 164, 340, 6, 107, "Input"],
Cell[5954, 172, 232, 3, 41, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

